<?php
class Shorten {
  // (A) PROPERTIES
  private $pdo = null;
  private $stmt = null;
  public $error;

  // (B) CONSTRUCTOR - CONNECT TO THE DATABASE
  function __construct () {
    try {
      $this->pdo = new PDO(
        "mysql:host=". DB_HOST .";dbname=". DB_NAME .";charset=". DB_CHARSET,
        DB_USER, DB_PASSWORD, [
          PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
          PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
          PDO::ATTR_EMULATE_PREPARES => false
        ]
      );
    } catch (Exception $ex) { exit($ex->getMessage()); }
  }

  // (C) DESTRUCTOR - CLOSE DATABSE CONNECTION
  function __destruct () {
    if ($this->stmt !== null) { $this->stmt = null; }
    if ($this->pdo !== null) { $this->pdo = null; }
  }

  // (D) GET BY LONG URL
  function getLong ($url) {
    $this->stmt = $this->pdo->prepare("SELECT * FROM `recipientlink_short_url` WHERE `url_long`=?");
    $this->stmt->execute([$url]);
    $url = $this->stmt->fetch();
    return is_array($url) ? $url : false ;
  }

  // (E) GET BY SHORT CODE
  function getShort ($code) {
    $this->stmt = $this->pdo->prepare("SELECT * FROM `recipientlink_short_url` WHERE `url_code`=?");
    $this->stmt->execute([$code]);
    $url = $this->stmt->fetch();
    echo ($url);
    return is_array($url) ? $url : false ;
  }

  // (F) GENERATE RANDOM STRING
  // CREDITS: https://stackoverflow.com/questions/4356289/php-random-string-generator
  function rand ($length = 6) {
    $char = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $clength = strlen($char);
    $rand = '';
    for ($i = 0; $i < $length; $i++) {
      $rand .= $char[rand(0, $clength - 1)];
    }
    return $rand;
  }

  // (G) GENERATE A NEW SHORT CODE FOR GIVEN URL
  function create ($url, $safe=true) {
    // (G1) "SAFE MODE" - DO NOT OVERRIDE LONG URL
    if ($safe) {
      if ($this->getLong($url) !== false) {
        $this->error = "$url is already defined.";
        return false;
      }
    }
    
    // (G2) GENERATE + CHECK RANDOM SHORT CODE
    $code = null;
    while ($code === null) {
      $rand = $this->rand();
      if ($this->getShort($rand) === false) { $code = $rand; }
    }

    // (G3) REPLACE ENTRY
    try {
      $this->stmt = $this->pdo->prepare("REPLACE INTO `recipientlink_short_url` (`url_long`, `url_code`) VALUES (?, ?)");
      $this->stmt->execute([$url, $code]);
      return $code;
    } catch (Exception $ex) {
      $this->error = $ex->getMessage();
      return false;
    }
  }

  // (H) DELETE ENTRY
  function del ($id) {
    try {
      $this->stmt = $this->pdo->prepare("DELETE FROM `recipientlink_short_url` WHERE `url_id`=?");
      $this->stmt->execute([$id]);
      return true;
    } catch (Exception $ex) {
      $this->error = $ex->getMessage();
      return false;
    }
  }
}

// (I) DATABASE SETTINGS
define('DB_HOST', 'localhost');
define('DB_NAME', 'db0');
define('DB_CHARSET', 'utf8');
define('DB_USER', 'root');
define('DB_PASSWORD', '_Rootserms123456');
define('URL_PATH_BASE', '/me2U/r/');

// (J) INIT
$_SHOURL = new Shorten();